//CTF_Stats.c - routines to display player stats

#include "g_local.h"

#define MOTD_FILE "MOTD.txt"
char TempString[256];
char		line[80];
/*
char WinText[6][17] =  {"* * * *** *    *\0",
						"* * *  *  **   *\0",
						"* * *  *  * *  *\0",
						"* * *  *  *  * *\0",
						"* * *  *  *   **\0",
						" ***  *** *    *\0"};

char DrawText[10][47] ={"*******     ********     ********   **  **  **\0",
						"**    **    **     **   **      **  **  **  **\0",
						"**     **   **      **  **      **  **  **  **\0",
						"**      **  **     **   **      **  **  **  **\0",
						"**      **  ********    **********  **  **  **\0",
						"**      **  **  **      **      **  **  **  **\0",
						"**      **  **   **     **      **  **  **  **\0",
						"**     **   **    **    **      **  **  **  **\0",
						"**    **    **     **   **      **  **  **  **\0",
						"*******     **      **  **      **   ******** \0"};

char WarriorText[5][40] =  {"* * *  **  ***  ***  ***  **  ***   ** \0",
							"* * * *  * *  * *  *  *  *  * *  * *   \0",
							"* * * **** ***  ***   *  *  * ***   ** \0",
							"* * * *  * * *  * *   *  *  * * *     *\0",
							" * *  *  * *  * *  * ***  **  *  *  ** \0"};

char RogueText[5][29] =	   {"***   **   **  *  * ***  ** \0",
							"*  * *  * *    *  * *   *   \0",
							"***  *  * * ** *  * **   ** \0",
							"* *  *  * *  * *  * *      *\0",
							"*  *  **   **   **  ***  ** \0"};
*/
char WinText[6][30] =  {"**  **  ** **** ***    **\0",
						"**  **  **  **  ****   **\0",
						"**  **  **  **  ** **  **\0",
						"**  **  **  **  **  ** **\0",
						"**  **  **  **  **   ****\0",
						" ********  **** **    ***\0"};

char DrawText[8][47] = {"********    *********    ********   **  **  **\0",
						"**     **   **      **  **      **  **  **  **\0",
						"**      **  **      **  **      **  **  **  **\0",
						"**      **  *********   **********  **  **  **\0",
						"**      **  **   **     **      **  **  **  **\0",
						"**      **  **    **    **      **  **  **  **\0",
						"**     **   **     **   **      **  **  **  **\0",
						"********    **      **  **      **   ******** \0"};

char WarriorText[5][46] =  {"* * *  ***  ****  ****  ***  ***  ****   *** \0",
							"* * * *   * *   * *   *  *  *   * *   * *    \0",
							"* * * ***** ****  ****   *  *   * ****   *** \0",
							"* * * *   * * *   * *    *  *   * * *       *\0",
							" * *  *   * *  *  *  *  ***  ***  *  *   *** \0"};

char RogueText[5][36] =	   {"****   ***   ***  *   * *****  *** \0",
							"*   * *   * *     *   * *     *    \0",
							"****  *   * *  ** *   * ***    *** \0",
							"* *   *   * *   * *   * *         *\0",
							"*  *   ***   ***   ***  *****  *** \0"};

#define SHOWCHASENAME\
	if (ent->client->chase_target && ent->client->chase_target->client)	{\
		ent->client->update_chase = false;\
		if(ent->client->chasemode == FREE_CHASE)\
		Com_sprintf(entry, sizeof(entry), "xm -180 yb -68 dmstr 773 \"Chasing %s in Freelook Mode\" xm -260 yb -40 dmstr 552 \".. [ and ] cycles, JUMP changes mode, ACTIVATE quits ..\" ",\
			ent->client->chase_target->client->pers.netname);\
		else if(ent->client->chasemode == EYECAM_CHASE)\
		Com_sprintf(entry, sizeof(entry), "xm -180 yb -68 dmstr 773 \"Chasing %s in Eyecam Mode\" xm -260 yb -40 dmstr 552 \".. [ and ] cycles, JUMP changes mode, ACTIVATE quits ..\" ",\
			ent->client->chase_target->client->pers.netname);\
		else if(ent->client->chasemode == LOCKED_CHASE)\
		Com_sprintf(entry, sizeof(entry), "xm -170 yb -68 dmstr 773 \"Chasing %s in Locked Mode\" xm -260 yb -40 dmstr 552 \".. [ and ] cycles, JUMP changes mode, ACTIVATE quits ..\" ",\
			ent->client->chase_target->client->pers.netname);\
		j = strlen(entry);\
		strcpy (string + stringlength, entry);\
		stringlength += j;\
	}

#define CHASEMESSAGE\
	if (!ent->client->chase_target) {\
		Com_sprintf (entry, sizeof(entry),\
			"xm %i yb -50 dmstr 773 \"%s\" ",\
			-5*23, "[hit ACTIVATE to chase]" );\
		j = strlen(entry);\
		strcpy (string + stringlength, entry);\
		stringlength += j;\
	}

void ForceShowMOTD(edict_t *ent)
{
	ent->client->showscores = FORCE_SCORE_MOTD;
	ent->client->resp.PlayerData.MOTDTime = level.time;
	gi.WriteByte (svc_layout);
	gi.WriteString (CTFGame.MOTD);
//	gi.unicast (ent, true);
}

void DisplayCTFMOTD(edict_t *ent)
{
	if(ent->client->showscores == FORCE_SCORE_MOTD)
	{
		if(level.time >= ent->client->resp.PlayerData.MOTDTime + FORCE_SHOW_MOTD_TIME)
		{
			ent->client->showscores = SCORE_MOTD;
//			return;
		}
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (CTFGame.MOTD);
//	gi.unicast (ent, true);
}

void LoadMOTD(void)
{
	FILE		*motd_file;
	int			j, x, y, stringlength;
	char		string[1400];
	char		file_name[256];
	cvar_t		*game_dir;
	char		rgb[] = "999";
	int NumLines = 0;

//	strcat(CTFGame.MOTD, string);
	CTFGame.MOTD[0] = 0;
	sprintf(TempString, "\"This server is running %s\"", GAMEVERSION);
	sprintf(CTFGame.MOTD, "yv -60 xm %i dmstr 7cf %s ", 0 - (strlen(TempString) * 5), TempString);
	for(j=1;j < (strlen(TempString) - 1);j++)
		TempString[j] = 0x2d;
	sprintf(string, "yv -48 xm %i dmstr 7cf %s ", 0 - (strlen(TempString) * 5), TempString);
	strcat(CTFGame.MOTD, string);

	j = 0;
	y = -40;
	stringlength = 0;
	string[0] = 0;
	game_dir = gi.cvar ("game", "", 0);	

#ifdef UNIX
	sprintf(file_name, "./%s/%s", game_dir->string, MOTD_FILE); 
#else
	sprintf(file_name, ".\\%s\\%s", game_dir->string, MOTD_FILE);
#endif

	if (motd_file = fopen(file_name, "r"))
	{
		while (( fgets(line, 80, motd_file) ) && (NumLines < 4) && (!feof(motd_file)))
		{
			char entry[512];
			char *s = line;
			int	 i, len = 0;

			for(j=0;j<512;j++)
				entry[j]=33;

			if (*s == '\n')
			{
				y += 20;
				NumLines++; // dont process blank lines
				continue;
			}

			if (s[0] == '/' && s[1] == '/')// dont process comments
			{
//				y += 18*2; 
				continue;
			}

			// Find the colour tags and adjust the positioning
			for (i=0; line[i] != '\n';i++)
			{
				len++;
				if (line[i] == '^')
					len -= 4;
			}
			x = -5 * len;
			y += 20;
			NumLines++;

			Com_sprintf (entry, sizeof(entry), 
				"xm %i yv %i dmstr %s \"", x , y, rgb);

			for (s = line;*s != '\n'; s++, x += 10)
			{
				if (*s == '^') {
					s++;// skip the '^'
					rgb[0] = *s;
					s++;// Red
					rgb[1] = *s;
					s++;// green
					rgb[2] = *s;
					strcat(entry, va("\" xm %i dmstr %s \"",x , rgb));
				}
				else
					strcat(entry, va("%c", *s));
			}
			strcat (entry,"\" ");
//			entry[strlen(entry)-1] = 0;

			strcat(CTFGame.MOTD, entry);

		}	
		fclose(motd_file);

		y += 22;
		sprintf(string, "xm %i yv %i dmstr 7cf %s", 0 - (strlen(TempString) * 5), y, TempString);
		strcat(CTFGame.MOTD, string);
		gi.dprintf("Message of the Day Init\n");
	}
	else
	{
		gi.dprintf("Message of the Day Fail\n");
	}
	y = 200;
	sprintf(string, "xm -300 yv %i dmstr f40 %s xm -225 dmstr 08f %s ", y, "\"Code:\"", "\"Captain Death\"");
	strcat(CTFGame.MOTD, string);
	y += 20;
	sprintf(string, "xm -300 yv %i dmstr f40 %s xm -225 dmstr 08f %s ", y, "\"Skins:\"", "\"DirtyDog\"");
	strcat(CTFGame.MOTD, string);
	y += 20;
	sprintf(string, "xm -300 yv %i dmstr f40 %s xm -225 dmstr 08f %s ", y, "\"Maps:\"", "\"Mr Damage, DirtyDog, Creamator, Hypov8\"");
	strcat(CTFGame.MOTD, string);
}

//Decides who the winner is and builds the display string
void DetermineWinner(void)
{
	char	string[1400];
	int LineCount;

	if(CTFGame.teamscore[0] > CTFGame.teamscore[1])
		CTFGame.Winner = WINNER_WARRIORS;
	else
	if(CTFGame.teamscore[0] < CTFGame.teamscore[1])
		CTFGame.Winner = WINNER_ROGUES;
	else
		CTFGame.Winner = WINNER_DRAW;

	string[0] = 0x00;
	CTFGame.WinnerMessage[0] = 0x00;
//	CTFGame.Winner = WINNER_WARRIORS;
//	CTFGame.Winner = WINNER_ROGUES;
	switch(CTFGame.Winner)
	{
		default:
			strcpy(CTFGame.WinnerMessage, "xm -220 ");
			for(LineCount = 0;LineCount < 8;LineCount++)
			{
				Com_sprintf(string, sizeof(string), "yv %i dmstr fff \"%s\" ", 0 + (LineCount * 10), DrawText[LineCount]);
				strcat(CTFGame.WinnerMessage, string);
			}
			break;
		case WINNER_WARRIORS:
			strcpy(CTFGame.WinnerMessage, "xm -220 ");
			for(LineCount = 0;LineCount < 5;LineCount++)
			{
				Com_sprintf(string, sizeof(string), "yv %i dmstr 00f \"%s\" ", -30 + (LineCount * 10), &WarriorText[LineCount]);
				strcat(CTFGame.WinnerMessage, string);
			}
			strcat(CTFGame.WinnerMessage, "xm -132 ");
			for(LineCount = 0;LineCount < 6;LineCount++)
			{
				Com_sprintf(string, sizeof(string), "yv %i dmstr fff \"%s\" ", 100 + (LineCount * 10), &WinText[LineCount]);
				strcat(CTFGame.WinnerMessage, string);
			}
			break;
		case WINNER_ROGUES:
			strcpy(CTFGame.WinnerMessage, "xm -175 ");
			for(LineCount = 0;LineCount < 5;LineCount++)
			{
				Com_sprintf(string, sizeof(string), "yv %i dmstr f00 \"%s\" ", -30 + (LineCount * 10), RogueText[LineCount]);
				strcat(CTFGame.WinnerMessage, string);
			}
			strcat(CTFGame.WinnerMessage, "xm -132 ");
			for(LineCount = 0;LineCount < 6;LineCount++)
			{
				Com_sprintf(string, sizeof(string), "yv %i dmstr fff \"%s\" ", 100 + (LineCount * 10), &WinText[LineCount]);
				strcat(CTFGame.WinnerMessage, string);
			}
			break;
	}
	CTFGame.EndgameTime = level.framenum;
}

void DisplayEndgameMessage(edict_t* ent)
{
//Displays the winning display string until the display time limit is reached
	gi.WriteByte (svc_layout);
	gi.WriteString (CTFGame.WinnerMessage);
}
